---
Difficulty: Medium
Source: Daily-Question(POTD 21-Nov)
Tags:
    - Array
    - Matrix
    - Simulation
---

# 🚀 *2257 - Count Unguarded Cells in the Grid* 🧠

### Problem Link:
[**LeetCode - Count Unguarded Cells in the Grid**](https://leetcode.com/problems/count-unguarded-cells-in-the-grid/?envType=daily-question&envId=2024-11-21)

## 💡 **Problem Breakdown:**

You are given two integers `m` and `n` representing a 0-indexed m x n grid. You are also given two 2D integer arrays `guards` and `walls` where `guards[i] = [rowi, coli]` and `walls[j] = [rowj, colj]` represent the positions of the ith guard and jth wall respectively.

A guard can see every cell in the four cardinal directions (north, east, south, or west) starting from their position unless obstructed by a wall or another guard. A cell is guarded if there is at least one guard that can see it.

### Your task:
Return the number of unoccupied cells that are **not guarded**.

## 🔍 **Example Walkthrough:**

### Example 1:
<img src="https://github.com/user-attachments/assets/76cc333d-24d5-4869-a58d-0e47d4b9b26d" width="34%">

**Input:**  
`m = 4, n = 6, guards = [[0,0],[1,1],[2,3]], walls = [[0,1],[2,2],[1,4]]`  
**Output:**  
`9`

**Explanation:**  
- We have a 4x6 grid.
- There are three guards and three walls.
- After processing the guards and walls, we count the number of cells that are not guarded.

### Example 2:
<img src="https://github.com/user-attachments/assets/88f4eea8-7a8d-472e-9466-7455bc192443" width="23%">

**Input:**  
`m = 3, n = 3, guards = [[0,0],[2,2]], walls = [[1,1]]`  
**Output:**  
`4`

**Explanation:**  
- After considering the walls and guards, four cells remain unguarded.

## 🎯 **My Approach:**

1. **Grid Initialization:**
   - Initialize a grid of size `m x n` filled with `0`, where `0` represents an unguarded cell.
   - Mark the positions of guards and walls on the grid.

2. **Simulate Guard Visibility:**
   - For each guard, simulate the visibility in all four directions (up, down, left, right).
   - Mark the cells that are visible to any guard, except for those blocked by walls or other guards.

3. **Count Unguarded Cells:**
   - After processing the guards' visibility, count the cells that are neither blocked by a wall nor visible to a guard.

4. **Return Result:**
   - Return the count of the remaining unguarded cells.

## 🕒 **Time Complexity:**

- **Time Complexity:** O(m * n) — We iterate over all cells to process guards and walls, which results in linear time complexity with respect to the grid size.
- **Space Complexity:** O(m * n) — We use a grid of size `m x n` to store the state of the cells.

## 📝 **Solution Code**

## Code (C++):

```cpp
class Solution {
public:
    int countUnguarded(int m, int n, vector<vector<int>>& guards, vector<vector<int>>& walls) {
        vector<int> grid(m * n, 0); 
        auto index = [&](int x, int y) { return x * n + y; }; 

        for (const auto& guard : guards) grid[index(guard[0], guard[1])] = 2;
        for (const auto& wall : walls) grid[index(wall[0], wall[1])] = 2;

        const int dirs[5] = {-1, 0, 1, 0, -1};

        for (const auto& guard : guards) {
            for (int d = 0; d < 4; ++d) {
                int x = guard[0], y = guard[1];
                int dx = dirs[d], dy = dirs[d + 1];
                while (true) {
                    x += dx;
                    y += dy;

                    if (x < 0 || x >= m || y < 0 || y >= n || grid[index(x, y)] == 2) break;

                    if (grid[index(x, y)] == 0) grid[index(x, y)] = 1;
                }
            }
        }

        return count(grid.begin(), grid.end(), 0);
    }
};
```

## Code (Java):

```java
class Solution {
    public int countUnguarded(int m, int n, int[][] guards, int[][] walls) {

        int[][] grid = new int[m][n];

        for (int[] guard : guards) grid[guard[0]][guard[1]] = 2;
        for (int[] wall : walls) grid[wall[0]][wall[1]] = 2;

        int[][] dirs = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};

        for (int[] guard : guards) {
            for (int[] dir : dirs) {
                int x = guard[0] + dir[0], y = guard[1] + dir[1];
                while (x >= 0 && x < m && y >= 0 && y < n && grid[x][y] != 2) {
                    if (grid[x][y] == 0) grid[x][y] = 1; 
                    x += dir[0];
                    y += dir[1];
                }
            }
        }

        int unguardedCount = 0;
        for (int i = 0; i < m; i++) {
            for (int j = 0; j < n; j++) {
                if (grid[i][j] == 0) unguardedCount++;
            }
        }

        return unguardedCount;
    }
}
```

## Code (Python3):

```python
class Solution:
    def countUnguarded(self, m: int, n: int, guards: List[List[int]], walls: List[List[int]]) -> int:

        grid = [[0] * n for _ in range(m)]

        for x, y in guards:
            grid[x][y] = 2
        for x, y in walls:
            grid[x][y] = 2

        directions = [(-1, 0), (1, 0), (0, -1), (0, 1)]

        for x, y in guards:
            for dx, dy in directions:
                nx, ny = x + dx, y + dy
                while 0 <= nx < m and 0 <= ny < n and grid[nx][ny] != 2:
                    if grid[nx][ny] == 0:  
                        grid[nx][ny] = 1
                    nx += dx
                    ny += dy

        return sum(cell == 0 for row in grid for cell in row)
```

## Code (C):

```c
int countUnguarded(int m, int n, int** guards, int guardsSize, int* guardsColSize, int** walls, int wallsSize, int* wallsColSize) {
    int* grid = (int*)calloc(m * n, sizeof(int));
    int index(int x, int y) { return x * n + y; }

    for (int i = 0; i < guardsSize; ++i) grid[index(guards[i][0], guards[i][1])] = 2;
    for (int i = 0; i < wallsSize; ++i) grid[index(walls[i][0], walls[i][1])] = 2;

    int dirs[5] = {-1, 0, 1, 0, -1};

    for (int i = 0; i < guardsSize; ++i) {
        for (int d = 0; d < 4; ++d) {
            int x = guards[i][0], y = guards[i][1];
            int dx = dirs[d], dy = dirs[d + 1];
            while (x + dx >= 0 && x + dx < m && y + dy >= 0 && y + dy < n && grid[index(x + dx, y + dy)] != 2) {
                x += dx;
                y += dy;
                if (grid[index(x, y)] == 0) grid[index(x, y)] = 1;
            }
        }
    }

    int count = 0;
    for (int i = 0; i < m * n; ++i) if (grid[i] == 0) count++;
    free(grid);
    return count;
}
```

## Code (Rust):

```rust
use std::collections::VecDeque;

impl Solution {
    pub fn count_unguarded(m: i32, n: i32, guards: Vec<Vec<i32>>, walls: Vec<Vec<i32>>) -> i32 {
        let (m, n) = (m as usize, n as usize);
        let mut grid = vec![vec![0; n]; m];

        for guard in &guards {
            grid[guard[0] as usize][guard[1] as usize] = 2;
        }
        for wall in &walls {
            grid[wall[0] as usize][wall[1] as usize] = 2;
        }

        let directions = [(-1, 0), (1, 0), (0, -1), (0, 1)];
        let mut queue = VecDeque::new();

        for guard in &guards {
            queue.push_back((guard[0] as usize, guard[1] as usize));
        }

        while let Some((x, y)) = queue.pop_front() {
            for &(dx, dy) in &directions {
                let (mut nx, mut ny) = (x as isize, y as isize);
                while {
                    nx += dx;
                    ny += dy;
                    nx >= 0 && nx < m as isize && ny >= 0 && ny < n as isize
                } {
                    let (ux, uy) = (nx as usize, ny as usize);
                    if grid[ux][uy] == 2 {
                        break; 
                    }
                    if grid[ux][uy] == 0 {
                        grid[ux][uy] = 1; 
                    }
                }
            }
        }

        grid.iter().flatten().filter(|&&cell| cell == 0).count() as i32
    }
}
```
# 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).


## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:25px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
